# Xylok Scan via Ansible (Single Package)

This package mirrors your original Python script using Ansible:
- Looks up the machine by `client_id` and `short_name`
- Requests the collection script and polls the background task
- Downloads, extracts, and runs `xylok-collect.sh`
- Finds the `.xylok` results file
- Uploads the results (multipart) and polls the task
- Fetches most recent scans (limit=2) and copies answers from the prior one (if present)
- Triggers AA and polls until complete

## Files
- `inventory` — Local inventory (localhost)
- `group_vars/all.yml` — **Central place to set variables** (API URL, token, client/machine IDs, work dir, polling, TLS)
- `xylok_scan.yml` — Top-level playbook
- `roles/xylok_scan/tasks/main.yml` — Main logic
- `roles/xylok_scan/defaults/main.yml` — Defaults (can be overridden by group_vars)

## Variables & Privileges
Edit `group_vars/all.yml`:
```yaml
api_url: "https://xylok.example.com"
api_token: "{{ lookup('env','XYLOK_API_TOKEN') | default('', true) }}"
client_id: "YOUR_CLIENT_PK_HERE"
short_name: "YOUR_MACHINE_SHORT_NAME_HERE"
validate_tls: false   # set to true when you have valid TLS certs
# become: true         # uncomment if you always want privilege escalation by default
```

**Privilege escalation:** If the collector requires root, run the play with `--become`:
```bash
ansible-playbook -i inventory xylok_scan.yml --become
```

You can also export your token instead of hard-coding it:
```bash
export XYLOK_API_TOKEN="YOUR_TOKEN"
```

## Run
```bash
cd xylok-ansible-scan
ansible-playbook -i inventory xylok_scan.yml       -e client_id=YOUR_CLIENT_PK       -e short_name=YOUR_MACHINE_SHORT_NAME       -e api_url=https://your-xylok       --become   # if needed
```

## Notes
- The upload step uses native `uri` multipart (`body_format: form-multipart`). If your Ansible version is old and errors on this,
  upgrade Ansible or replace the upload step with a `curl` command.
- TLS: `validate_tls: false` replicates your Python's blank `SSLContext`. Set to `true` for strict verification.
- Working dir: override `workdir` in `group_vars/all.yml` if desired.
- Polling cadence can be tuned via `poll_delay_seconds` and `poll_retries_*` in `group_vars/all.yml`.
